/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.heuristic;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternJoin;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Probability;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.List;

public class ProbabilisticFrameworkJoin
extends HeuristicBasicPattern {
    private Probability probability;

    public ProbabilisticFrameworkJoin(Context context) {
        this.probability = (Probability)context.get(Constants.PF);
    }

    public double getCost(Triple triple1) {
        if (this.probability == null) {
            throw new NullPointerException("The probability framework has not been set to the ARQ context!");
        }
        return this.probability.getProbability(triple1);
    }

    public double getCost(Triple triple1, Triple triple2) {
        if (this.probability == null) {
            throw new NullPointerException("The probability framework has not been set to the ARQ context!");
        }
        List joins = BasicPatternJoin.specificTypes(triple1, triple2);
        if (joins.contains("http://jena.hpl.hp.com/ARQo/join#bPP")) {
            return 1.0;
        }
        return this.probability.getProbability(triple1) + this.probability.getProbability(triple1, triple2);
    }
}

