/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;

public class AggCount
implements AggregateFactory {
    private static AggCount singleton = new AggCount();

    public static AggregateFactory get() {
        return singleton;
    }

    private AggCount() {
    }

    public Aggregator create() {
        return new AggCountWorker();
    }

    static class AccCount
    implements Accumulator {
        private long count = 0L;

        public void accumulate(Binding binding) {
            ++this.count;
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }

    static class AggCountWorker
    extends AggregatorBase {
        public String toString() {
            return "count(*)";
        }

        public String toPrefixString() {
            return "(count)";
        }

        protected Accumulator createAccumulator() {
            return new AccCount();
        }

        public Node getValueEmpty() {
            return NodeValue.nodeIntZERO;
        }
    }
}

