% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_observation_expected.R
\name{util_observation_expected}
\alias{util_observation_expected}
\title{Detect Expected Observations}
\usage{
util_observation_expected(
  rv,
  study_data,
  meta_data,
  label_col = LABEL,
  expected_observations = c("HIERARCHY", "ALL", "SEGMENT")
)
}
\arguments{
\item{rv}{\link{character} the response variable, for that a value may be expected}

\item{study_data}{\link{study_data}}

\item{meta_data}{\link{meta_data}}

\item{label_col}{\link{character} mapping attribute \code{colnames(study_data)} vs.
\code{meta_data[label_col]}}

\item{expected_observations}{\link{enum} HIERARCHY | ALL | SEGMENT. How should
\code{PART_VARS} be handled:
- \code{ALL}: Ignore, all observations are
expected
- \code{SEGMENT}: if \code{PART_VAR} is 1, an
observation is expected
- \code{HIERARCHY}: the default, if the
\code{PART_VAR} is 1 for this variable and
also for all \code{PART_VARS} of \code{PART_VARS}
up in the hierarchy, an observation is
expected.}
}
\value{
a vector with \code{TRUE} or \code{FALSE} for each row of \code{study_data}, if for
\code{study_data[rv]} a value is expected.
}
\description{
For each participant, check, if an observation was expected, given the
\code{PART_VARS} from item-level metadata
}
