% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_parse_redcap_rule.R
\name{util_parse_redcap_rule}
\alias{util_parse_redcap_rule}
\title{Interpret a \code{REDcap}-style rule and create an expression, that represents this rule}
\usage{
util_parse_redcap_rule(
  rule,
  debug = 0,
  entry_pred = "REDcapPred",
  must_eof = FALSE
)
}
\arguments{
\item{rule}{\link{character} \code{REDcap} style rule}

\item{debug}{\link{integer} debug level (0 = off, 1 = log, 2 = breakpoints)}

\item{entry_pred}{\link{character} for debugging reasons: The production
rule used entry point for the parser}

\item{must_eof}{\link{logical} if \code{TRUE}, expect the input to be \code{eof}, when the
parser succeeded, fail, if not.}
}
\value{
\link{expression} the interpreted rule

\href{https://help.redcap.ualberta.ca/help-and-faq/project-best-practices/data-quality/example-data-quality-rules}{\code{REDcap} rules 1}
\href{https://www.ctsi.ufl.edu/files/2017/06/Calculated-Fields-\%E2\%80\%93-REDCap-How.pdf}{\code{REDcap} rules 2}
\href{https://www.iths.org/wp-content/uploads/REDCap-Branching-Logic-2017-202.pdf}{\code{REDcap} rules 3}

For resolving left-recursive rules,
\href{https://stackoverflow.com/a/9934631}{StackOverflow}
helps understanding the grammar below, just in case, theoretical computer
science is not right in your mind currently.
}
\description{
Interpret a \code{REDcap}-style rule and create an expression, that represents this rule
}
\examples{
\dontrun{
#  rules:
# pregnancies <- 9999 ~ SEX == 'm' |  is.na(SEX)
# pregnancies <- 9998 ~ AGE < 12 |  is.na(AGE)
# pregnancies = 9999 ~ dist > 2 |  speed == 0

data.frame(target = "SEX_0",
  rule = '[speed] > 5 and [dist] > 42 or 1 = "2"',
  CODE = 99999, LABEL = "PREGNANCIES_NOT_ASSESSED FOR MALES",
  class = "JUMP")
ModifyiedStudyData <- replace in SEX_0 where SEX_0 is empty, if rule fits
ModifyedMetaData <- add missing codes with labels and class here

subset(study_data, eval(pregnancies[[3]]))

rule <-
 paste0('[con_consentdt] <> "" and [sda_osd1dt] <> "" and',
 ' datediff([con_consentdt],[sda_osd1dt],"d",true) < 0')

x <- data.frame(con_consentdt = c(as.POSIXct("2020-01-01"),
                as.POSIXct("2020-10-20")),
                sda_osd1dt = c(as.POSIXct("2020-01-20"),
                as.POSIXct("2020-10-01")))
eval(util_parse_redcap_rule(paste0(
  '[con_consentdt] <> "" and [sda_osd1dt] <> "" and ',
  'datediff([con_consentdt],[sda_osd1dt],"d", "Y-M-D",true) < 10')),
  x, util_get_redcap_rule_env())

util_parse_redcap_rule("[a] = 12 or [b] = 13")
cars[eval(util_parse_redcap_rule(
  rule = '[speed] > 5 and [dist] > 42 or 1 = "2"'), cars,
  util_get_redcap_rule_env()), ]
cars[eval(util_parse_redcap_rule(
  rule = '[speed] > 5 and [dist] > 42 or 2 = "2"'), cars,
  util_get_redcap_rule_env()), ]
cars[eval(util_parse_redcap_rule(
  rule = '[speed] > 5 or [dist] > 42 and 1 = "2"'), cars,
  util_get_redcap_rule_env()), ]
cars[eval(util_parse_redcap_rule(
  rule = '[speed] > 5 or [dist] > 42 and 2 = "2"'), cars,
  util_get_redcap_rule_env()), ]
util_parse_redcap_rule(rule = '(1 = "2" or true) and (false)')
eval(util_parse_redcap_rule(rule =
  '[dist] > sum(1, +(2, [dist] + 5), [speed]) + 3 + [dist]'),
cars, util_get_redcap_rule_env())
}

}
\seealso{
Other parser_functions: 
\code{\link{util_interpret_limits}()},
\code{\link{util_interpret_range}()},
\code{\link{util_parse_assignments}()},
\code{\link{util_parse_interval}()}
}
\concept{metadata_management}
\concept{parser_functions}
\keyword{internal}
