% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_varcomp_robust.R
\name{util_varcomp_robust}
\alias{util_varcomp_robust}
\title{Utility function to compute the rank intraclass correlation}
\usage{
util_varcomp_robust(
  resp_vars = NULL,
  group_vars = NULL,
  study_data = study_data,
  meta_data = meta_data,
  min_obs_in_subgroup = 10,
  min_subgroups = 5,
  label_col = NULL
)
}
\arguments{
\item{resp_vars}{the name of the response variable}

\item{group_vars}{the name of the grouping variable}

\item{study_data}{the data frame that contains the measurements}

\item{meta_data}{the data frame that contains metadata attributes of
study data}

\item{min_obs_in_subgroup}{the minimum number of observations that is
required to include a subgroup (level) of the
grouping variable (\code{group_vars}) in the analysis.
Subgroups with fewer observations are excluded.}

\item{min_subgroups}{the minimum number of subgroups (levels) of the
grouping variable (\code{group_vars}). If the variable has
fewer subgroups, the analysis is not performed.}

\item{label_col}{the name of the column in the metadata with labels of
variables}
}
\value{
a vector from rankICC::rankICC
}
\description{
This implementation uses the package \code{rankICC} to compute the rank
intraclass correlation, a nonparametric version of the ICC (Tu et al., 2023).
In contrast to model-based ICC approaches, it is less sensitive to outliers
and skewed distributions. It can be applied to variables with an ordinal,
interval or ratio scale. However, it is not possible to adjust for
covariables with this approach. The calculated ICC can become negative,
like Fisher's ICC.
}
