% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_warn_unordered.R
\name{util_warn_unordered}
\alias{util_warn_unordered}
\title{Warn about a problem in \code{varname}, if \code{x} has no natural order}
\usage{
util_warn_unordered(x, varname)
}
\arguments{
\item{x}{\link{vector} of data}

\item{varname}{\link{character} len=1. Variable name for warning messages}
}
\value{
invisible(NULL)
}
\description{
Also warns, if R does not have a comparison operator for \code{x}.
}
\seealso{
Other robustness_functions: 
\code{\link{util_as_valid_missing_codes}()},
\code{\link{util_check_one_unique_value}()},
\code{\link{util_correct_variable_use}()},
\code{\link{util_empty}()},
\code{\link{util_ensure_character}()},
\code{\link{util_ensure_in}()},
\code{\link{util_ensure_suggested}()},
\code{\link{util_expect_scalar}()},
\code{\link{util_fix_rstudio_bugs}()},
\code{\link{util_is_integer}()},
\code{\link{util_is_numeric_in}()},
\code{\link{util_is_valid_missing_codes}()},
\code{\link{util_match_arg}()},
\code{\link{util_observations_in_subgroups}()},
\code{\link{util_stop_if_not}()}
}
\concept{robustness}
\concept{robustness_functions}
\keyword{internal}
