% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetFrozenModel}
\alias{GetFrozenModel}
\title{Retrieve the details of a specified frozen model}
\usage{
GetFrozenModel(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{Unique alphanumeric identifier for the model of interest.}
}
\value{
An S3 object of class `dataRobotModel', which is a list
with the following components:
\itemize{
  \item featurelistId. Character string: unique alphanumeric identifier for the featurelist on
    which the model is based.
  \item processes. Character vector with components describing preprocessing; may include
    modelType.
  \item featurelistName. Character string giving the name of the featurelist on which the model
    is based.
  \item projectId. Character string giving the unique alphanumeric identifier for the project.
  \item samplePct. Numeric or NULL. The percentage of the project dataset used in training the
    model. If the project uses datetime partitioning, the \code{samplePct} will be NULL.
    See \code{trainingRowCount}, \code{trainingDuration}, and \code{trainingStartDate}
    and \code{trainingEndDate} instead.
  \item trainingRowCount. Integer. The number of rows of the project dataset used in training
    the model. In a datetime partitioned project, if specified, defines the number of
    rows used to train the model and evaluate backtest scores; if unspecified, either
    \code{trainingDuration} or \code{trainingStartDate} and \code{trainingEndDate} was used to
    determine that instead.
  \item isFrozen. Logical : is model created with frozen tuning parameters.
  \item modelType. Character string describing the model type.
  \item metrics. List with one element for each valid metric associated with the model. Each
    element is a list with elements for each possible evaluation type (holdout, validation,
    and crossValidation).
  \item modelCategory. Character string giving model category (e.g., blend, model).
  \item blueprintId. Character string giving the unique DataRobot blueprint identifier on which
    the model is based.
  \item modelId. Character string giving the unique alphanumeric model identifier.
  \item projectName. Character string: optional description of project defined by projectId.
  \item projectTarget. Character string defining the target variable predicted by all models in
    the project.
  \item projectMetric. Character string defining the fitting metric optimized by all project
    models.
  \item supportsMonotonicConstraints logical. Whether or not the model supports monotonic
    constraints.
  \item monotonicIncreasingFeaturelistId character. The ID of the featurelist specifying the
    features that are constrained to be monotonically increasing. Will be \code{NULL} if no
    increasing constraints are used.
  \item monotonicDecreasingFeaturelistId character. The ID of the featurelist specifying the
    features that are constrained to be monotonically decreasing. Will be \code{NULL} if no
    decreasing constraints are used.
  \item isStarred logical. Whether or not the model is starred.
  \item predictionThreshold numeric. For binary classification projects, the threshold used
    for predictions.
  \item predictionThresholdReadOnly logical. Whether or not the prediction threshold can be
    modified. Typically, the prediction threshold can no longer be modified once a model has
    a deployment created or predictions have been made with the dedicated prediction API.
}
}
\description{
This function returns a DataRobot S3 object of class
dataRobotFrozenModel for the model defined by project and modelId.
GetModel also can be used to retrieve some information about
frozen model, however then some frozen specific information (parentModelId)
will not be returned
}
\details{
The S3 object returned by this function is required by the
functions DeleteModel, ListModelFeatures, and RequestSampleSizeUpdate.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  GetFrozenModel(projectId, modelId)
}
}
