% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{ReplaceDeployedModel}
\alias{ReplaceDeployedModel}
\title{Replace a model in a deployment with another model.}
\usage{
ReplaceDeployedModel(
  deploymentId,
  newModelId,
  replacementReason,
  maxWait = 600
)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}

\item{newModelId}{character. The ID of the model to use in the deployment. This model
will replace the old model. You can also pass a dataRobotModel object.}

\item{replacementReason}{character. Optional. The reason for replacing the deployment.
See \code{ModelReplacementReason} for a list of reasons.}

\item{maxWait}{integer. How long to wait (in seconds) for the computation to complete
before returning a timeout error? (Default 600 seconds)}
}
\value{
A DataRobotDeployment object containing:
\itemize{
 \item id character. The ID of the deployment.
 \item label character. The label of the deployment.
 \item description character. The description of the deployment.
 \item defaultPredictionServer list. Information on the default prediction
   server connected with the deployment. See \code{ListPredictionServers}
   for details.
 \item model dataRobotModel. The model associated with the deployment.
   See \code{GetModel} for details.
 \item capabilities list. Information on the capabilities of the deployment.
 \item predictionUsage list. Information on the prediction usage of the deployment.
 \item serviceHealth list. Information on the service health of the deployment.
 \item modelHealth list. Information on the model health of the deployment.
 \item accuracyHealth list. Information on the accuracy health of the deployment.
}
}
\description{
Replace a model in a deployment with another model.
}
\examples{
\dontrun{
  deploymentId <- "5e319d2e422fbd6b58a5edad"
  newModelId <- "5996f820af07fc605e81ead4"
  ReplaceDeployedModel(deploymentId, newModelId, ModelReplacementReason$Other)
}
}
