% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject.R
\name{subject}
\alias{subject}
\alias{subject_create}
\alias{subject<-}
\alias{is.subject}
\title{Create/add/retrieve a subject}
\usage{
subject(x)

subject_create(
  term,
  schemeURI = NULL,
  valueURI = NULL,
  prefix = NULL,
  subjectScheme = NULL,
  classificationCode = NULL
)

subject(x, overwrite = FALSE) <- value

is.subject(x)
}
\arguments{
\item{x}{A dataset object created with \code{dataset::\link{dataset}}.}

\item{term}{A subject term, for example, \code{"Data sets"}.}

\item{schemeURI}{The URI of the subject identifier scheme, for example
\code{"http://id.loc.gov/authorities/subjects"}}

\item{valueURI}{The URI of the subject term.
\code{"https://id.loc.gov/authorities/subjects/sh2018002256"}}

\item{prefix}{An abbreviated prefix of a scheme URI, for example,
\code{"lcch:"} representing \code{"http://id.loc.gov/authorities/subjects"}.
Widely used namespaces (schemes) have conventional abbreviations.}

\item{subjectScheme}{The name of the subject scheme or classification code or
authority if one is used. It is a namespace.}

\item{classificationCode}{The classificationCode subproperty may be used for
subject schemes, like ANZSRC, which do not have valueURIs for each subject term.}

\item{overwrite}{If the attributes should be overwritten. In case it is set to \code{FALSE},
it gives a message with the current \code{Subject} property instead of overwriting it.
Defaults to \code{FALSE}.}

\item{value}{A subject field created by \code{\link{subject}}.}
}
\value{
The Subject field of the dataset's attributes.

A named list with the subject term, the subject scheme, URIs and prefix.
}
\description{
Create/add/retrieve a subject
}
\examples{
subject(iris_dataset,
        overwrite = TRUE) <- subject_create(
                                  term  = "Irises (plants)",
                                  schemeURI = "http://id.loc.gov/authorities/subjects",
                                  valueURI = "https://id.loc.gov/authorities/subjects/sh85068079",
                                  subjectScheme = "LCCH",
                                  prefix = "lcch:")
subject(iris_dataset)
}
