% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_clear.R, R/ds_deque.R, R/ds_heap.R,
%   R/ds_map.R
\docType{methods}
\name{clear}
\alias{clear}
\alias{clear,deque-method}
\alias{clear,heap-method}
\alias{clear,map-method}
\title{Remove all elements from a datastructure}
\usage{
clear(obj)

\S4method{clear}{deque}(obj)

\S4method{clear}{heap}(obj)

\S4method{clear}{map}(obj)
}
\arguments{
\item{obj}{the object to clear}
}
\description{
Removes every element that is stored in a data structure and
 resets everything.
}
\examples{

 # clears a multimap
 m_map <- multimap()
 m_map <- insert(m_map, c("a", "b"), 1:2)
 m_map <- insert(m_map, c("a", "b"), list(1, list(a=1)))
 m_map <- clear(m_map)


 # clears a heap
 f_heap <- fibonacci_heap("integer")
 f_heap <- insert(f_heap, 1:2, 1:2)
 f_heap[3:4] <-  list(1, list(a=1))
 f_heap <- clear(f_heap)

 # clears a \\code{deque}
 s <- stack()
 s <- insert(s, list(1, vector(), list(3), data.frame(rnorm(3))))
 s <- clear(s)

}
