% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_addprefix.R, R/data_rename.R
\name{data_addprefix}
\alias{data_addprefix}
\alias{data_addsuffix}
\alias{data_rename}
\alias{data_rename_rows}
\title{Rename columns and variable names}
\usage{
data_addprefix(
  data,
  pattern,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  ...
)

data_addsuffix(
  data,
  pattern,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  ...
)

data_rename(data, pattern = NULL, replacement = NULL, safe = TRUE, ...)

data_rename_rows(data, rows = NULL)
}
\arguments{
\item{data}{A data frame, or an object that can be coerced to a data frame.}

\item{pattern}{Character vector. For \code{data_rename()}, indicates columns that
should be selected for renaming. Can be \code{NULL} (in which case all columns
are selected). For \code{data_addprefix()} or \code{data_addsuffix()}, a character
string, which will be added as prefix or suffix to the column names.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item or one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")}.
}

If \code{NULL}, selects all columns.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{...}{Other arguments passed to or from other functions.}

\item{replacement}{Character vector. Indicates the new name of the columns
selected in \code{pattern}. Can be \code{NULL} (in which case column are numbered
in sequential order). If not \code{NULL}, \code{pattern} and \code{replacement} must be
of the same length.}

\item{safe}{Do not throw error if for instance the variable to be
renamed/removed doesn't exist.}

\item{rows}{Vector of row names.}
}
\value{
A modified data frame.
}
\description{
Safe and intuitive functions to rename variables or rows in
data frames. \code{data_rename()} will rename column names, i.e. it facilitates
renaming variables \code{data_addprefix()} or \code{data_addsuffix()} add prefixes
or suffixes to column names. \code{data_rename_rows()} is a convenient shortcut
to add or rename row names of a data frame, but unlike \code{row.names()}, its
input and output is a data frame, thus, integrating smoothly into a possible
pipe-workflow.
}
\examples{
# Add prefix / suffix to all columns
head(data_addprefix(iris, "NEW_"))
head(data_addsuffix(iris, "_OLD"))

# Rename columns
head(data_rename(iris, "Sepal.Length", "length"))
# data_rename(iris, "FakeCol", "length", safe=FALSE)  # This fails
head(data_rename(iris, "FakeCol", "length")) # This doesn't
head(data_rename(iris, c("Sepal.Length", "Sepal.Width"), c("length", "width")))

# Reset names
head(data_rename(iris, NULL))

# Change all
head(data_rename(iris, paste0("Var", 1:5)))

}
\seealso{
\itemize{
\item Functions to rename stuff: \code{\link[=data_rename]{data_rename()}}, \code{\link[=data_rename_rows]{data_rename_rows()}}, \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}}, \code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate dataframes: \code{\link[=data_to_long]{data_to_long()}}, \code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to rescale and reverse: \code{\link[=data_rescale]{data_rescale()}}, \code{\link[=data_reverse]{data_reverse()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split, cut and merge dataframes: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_cut]{data_cut()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=find_columns]{find_columns()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
