% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppm.R
\encoding{UTF-8}
\name{load_ppm}
\alias{load_ppm}
\title{PPM - Municipal Livestock Production}
\usage{
load_ppm(dataset = NULL, raw_data, geo_level, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("ppm_livetock_inventory", "ppm_sheep_farming", "ppm_animal_orig_production", "ppm_cow_farming" or "ppm_aquaculture". You can also use SIDRA codes (see \url{https://sidra.ibge.gov.br/pesquisa/ppm/tabelas/brasil/2019})}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality". See documentation of \code{sidrar}.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} consisting of geographic units that present positive values for any of the variables in the dataset.
}
\description{
Loads information on animal farming inventories and livestock products (IBGE). Survey is done at the municipal level and data is available from 1974 to 2019 for most datasets. See \url{https://www.ibge.gov.br/en/statistics/economic/agriculture-forestry-and-fishing/17353-municipal-livestock-production.html?=&t=o-que-e}
}
\examples{
\dontrun{
# download state raw data from 2012 for animal origin production
ppm_aop <- load_ppm(dataset = 'ppm_animal_origin_production',
                    raw_data = TRUE,
                    geo_level = 'state',
                    time_period = 2012)
}
}
