% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_phylo.R
\name{choose_cluster}
\alias{choose_cluster}
\title{Choose an ultrametric phylo object from \code{\link[=cluster_patristicmatrix]{cluster_patristicmatrix()}} obtained
with a particular clustering method, or the next best tree.
If there are no ultrametric trees, it does not force them to be ultrametric.}
\usage{
choose_cluster(phycluster, clustering_method = "nj")
}
\arguments{
\item{phycluster}{An output from \code{\link[=cluster_patristicmatrix]{cluster_patristicmatrix()}}}

\item{clustering_method}{A character vector indicating the method to construct
the tree. Options are:
\describe{
\item{nj}{Neighbor-Joining method applied with \code{\link[ape:nj]{ape::nj()}}.}
\item{upgma}{Unweighted Pair Group Method with Arithmetic Mean method applied
with \code{\link[phangorn:upgma]{phangorn::upgma()}}.}
\item{bionj}{An improved version of the Neighbor-Joining method applied with
\code{\link[ape:bionj]{ape::bionj()}}.}
\item{triangle}{Triangles method applied with \code{\link[ape:triangMtd]{ape::triangMtd()}}}
\item{mvr}{Minimum Variance Reduction method applied with \code{\link[ape:mvr]{ape::mvr()}}.}
}}
}
\value{
A \code{phylo} object or \code{NA}.
}
\description{
Choose an ultrametric phylo object from \code{\link[=cluster_patristicmatrix]{cluster_patristicmatrix()}} obtained
with a particular clustering method, or the next best tree.
If there are no ultrametric trees, it does not force them to be ultrametric.
}
