% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_taxonomy.R
\name{clean_taxon_info_children}
\alias{clean_taxon_info_children}
\title{Identify, extract and clean taxonomic children names from a \code{\link[=taxonomy_taxon_info]{taxonomy_taxon_info()}}
output.}
\usage{
clean_taxon_info_children(
  taxon_info,
  invalid = c("barren", "extinct", "uncultured", "major_rank_conflict", "incertae_sedis",
    "unplaced", "conflict", "environmental", "not_otu", "hidden", "hybrid")
)
}
\arguments{
\item{taxon_info}{An output of \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}}.}

\item{invalid}{A character vector of "flags", i.e., characteristics that are
used by Open Tree of Life Taxonomy to detect invalid taxon names.}
}
\value{
A list with valid children unique OTT names, OTT ids and taxonomic ranks.
}
\description{
\code{clean_taxon_info_children} eliminates all taxa that will give
problems when trying to retrieve an induced subtree from Open Tree of Life.
}
