% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-col-names.R
\name{check_col_names}
\alias{check_col_names}
\alias{check_cols_manifest}
\alias{check_cols_individual}
\alias{check_cols_assay}
\alias{check_cols_biospecimen}
\title{Check column names against their corresponding template}
\usage{
check_col_names(
  data,
  template,
  success_msg = NULL,
  fail_msg = NULL,
  behavior = NULL
)

check_cols_manifest(
  data,
  id,
  success_msg = "All manifest columns present",
  fail_msg = "Missing columns in the manifest",
  ...
)

check_cols_individual(
  data,
  id,
  success_msg = "All individual metadata columns present",
  fail_msg = "Missing columns in the individual metadata file",
  ...
)

check_cols_assay(
  data,
  id,
  success_msg = "All assay metadata columns present",
  fail_msg = "Missing columns in the assay metadata file",
  ...
)

check_cols_biospecimen(
  data,
  id,
  success_msg = "All biospecimen columns present",
  fail_msg = "Missing columns in the biospecimen metadata file",
  ...
)
}
\arguments{
\item{data}{Data frame to check against template (manifest, individual
metadata, or assay metadata)}

\item{template}{Character vector of column names from the template to check
against}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}

\item{behavior}{The intended behavior of the test}

\item{id}{Synapse ID of the template to check against}

\item{...}{Additional arguments passed to syn$get()}
}
\value{
A condition object indicating whether the required columns were
present (\code{"check_pass"}) or absent (\code{"check_fail"}).
}
\description{
Check column names against their corresponding template
}
\examples{
template <- c("individualID", "specimenID", "assay")
dat <- data.frame(individualID = c("a", "b"), specimenID = c("a1", "b1"))
check_col_names(dat, template)
\dontrun{
syn <- synapse$Synapse()
syn$login()

a <- data.frame(path = "/path/file.txt", parent = "syn123", assay = "rnaSeq")
check_cols_manifest(a, syn)

b <- data.frame(assay = "rnaSeq")
check_cols_manifest(b, syn)
}
}
\seealso{
\code{\link[dccvalidator:get_template]{dccvalidator::get_template()}}
}
