% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdcov.R
\name{mdcov}
\alias{mdcov}
\alias{mdcor}
\title{Marginal distance covariance
This function implements the method of calculating distance covariance between y
and each column in x}
\usage{
mdcov(y, x, type = c("V", "U"))

mdcor(y, x, type = c("V", "U"))
}
\arguments{
\item{y}{the matrix of y}

\item{x}{the matrix of x, distance covariance is calculated for each variable
in x with y.}

\item{type}{"V" or "U", for V- or U-statistics of distance covariance or
correlation. The default value is "V".}
}
\description{
Marginal distance covariance
This function implements the method of calculating distance covariance between y
and each column in x
}
\examples{
n = 200; p = 10
y = matrix(rnorm(n*2),n,2)
x = matrix(rnorm(n*p),n,p)
res1 = mdcov(y,x)
res2 = numeric(p)
for(j in 1:p){res2[j] = dcov::dcov(y,x[,j])}
# res1 is same with res2
res1 - res2
res3 = mdcor(y,x)
res4 = numeric(p)
for(j in 1:p){res4[j] = dcov::dcor(y,x[,j])}
# res3 is same with res4
res3-res4
}
