% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnpp_experiment-plot.R
\name{plot.pnpp_experiment}
\alias{plot.pnpp_experiment}
\title{Plot a ddPCR plate of type PNPP experiment}
\usage{
\method{plot}{pnpp_experiment}(x, wells, samples, ...,
  col_drops_negative = "purple3", col_drops_positive = "green3",
  col_drops_rain = "black", show_negative_freq = TRUE,
  text_size_negative_freq = 4, alpha_drops_low_negative_freq = 0.5,
  show_low_high_neg_freq = TRUE, bg_negative = "purple3",
  bg_positive = "green3", alpha_bg_low_high_neg_freq = 0.1,
  superimpose = FALSE, show_drops = TRUE, drops_size = 1)
}
\arguments{
\item{x}{A ddPCR plate.}

\item{wells}{Only plot selected wells. Supports range notation, see
\code{\link[ddpcr]{subset.ddpcr_plate}}.}

\item{samples}{Only plot selected samples.}

\item{...}{Parameters to pass to \code{\link[ddpcr]{plot.ddpcr_plate}}.}

\item{col_drops_negative}{The colour to use for negative droplets.
See 'Droplet visibility options' for \code{\link[ddpcr]{plot.ddpcr_plate}}.}

\item{col_drops_positive}{The colour to use for positive droplets.
See 'Droplet visibility options' for \code{\link[ddpcr]{plot.ddpcr_plate}}.}

\item{col_drops_rain}{The colour to use for rain droplets.
See 'Droplet visibility options' for \code{\link[ddpcr]{plot.ddpcr_plate}}.}

\item{show_negative_freq}{If \code{TRUE}, show the negative frequency
as a percentage on each well.}

\item{text_size_negative_freq}{Text size of the printed negative frequencies.}

\item{alpha_drops_low_negative_freq}{Transparency of negative droplets
in wells with mostly positive droplets. In wells where there are very few
negative droplets, it might be useful to make them more visible by increasing
their transparency.}

\item{show_low_high_neg_freq}{Differentiate between wells with a high vs
low negative frequency by having a different background colour to the well.}

\item{bg_negative}{The background colour for wells that have a significant
negative cluster.}

\item{bg_positive}{The background colour for wells that have mostly positive
drops.}

\item{alpha_bg_low_high_neg_freq}{The transparency value for \code{bg_negative}
and \code{bg_positive}.}

\item{superimpose}{If \code{TRUE}, show all wells superimposed in one plot;
otherwise, show wells in a grid.}

\item{show_drops}{Whether or not to show the droplets. Setting to \code{FALSE}
is not useful if the droplets are the only thing shown in the plot, but it
can be useful if there is other information depicated in the plot, such as
any background colours or text that may appear in each well.}

\item{drops_size}{Size of droplets.}
}
\value{
A ggplot2 plot object.
}
\description{
Same plot as \code{\link[ddpcr]{plot.ddpcr_plate}} but with a few extra
features that are specific to PNPP experiments The main additions are that
the negative frequency of each well can be written in each well, and well
background colours can be used to differentiate between wells with a
significant negative cluster vs wells with mostly positive drops. Take a look
at \code{\link[ddpcr]{plot.ddpcr_plate}} to see all supported parameters
and more information.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$pnpp_experiment)
positive_dim(plate) <- "Y"
plot(plate)
plate <- plate \%>\% analyze
plot(plate)
plot(plate, "B01:C06", col_drops_rain = "blue")
}
}
\seealso{
\code{\link[ddpcr]{plot.ddpcr_plate}}\cr
\code{\link[ddpcr]{pnpp_experiment}}
}
\keyword{internal}

