% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-ddpcr_plate.R
\name{ddpcr_plate}
\alias{ddpcr_plate}
\title{Plate type: ddPCR plate}
\description{
The default plate type that all other plates inherit from. If you initialize
a ddPCR plate without specifying a plate type, \code{ddpcr_plate} will be the
plate's type.
}
\details{
Plates with this type have the following analysis steps: \code{INITIALIZE},
\code{REMOVE_FAILURES}, \code{REMOVE_OUTLIERS}, \code{REMOVE_EMPTY}.

Plates with this type have the following droplet clusters: \code{UNDEFINED},
\code{FAILED}, \code{OUTLIER}, \code{EMPTY}.

\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on plate types.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$ddpcr_plate)
type(plate)
plate \%>\% analyze \%>\% plot
} 
}
\seealso{
\code{\link[ddpcr]{plate_types}}\cr
\code{\link[ddpcr]{remove_failures}}\cr
\code{\link[ddpcr]{remove_outliers}}\cr
\code{\link[ddpcr]{remove_empty}}
}
