% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Fried1993}
\alias{Fried1993}
\title{Data: Fried, Knox Lovell and Schmidt (1993).}
\format{Data frame with 11 rows and 4 columns. Definition of inputs (X) and outputs (Y):
\describe{
  \item{x1}{Input 1}
  \item{x2}{Input 2}
  \item{y1}{Output 1}
}}
\source{
Ali, A.I.; Seiford, L.M. (1993). The Mathematical Programming Approach to Efficiency Analysis. In Fried, H.O.; Knox Lovell, C.A.; Schmidt, S.S.(eds.), The Measurement of Productive Efficiency. Techniques and Applications. New York: Oxford University Press.
}
\usage{
data("Fried1993")
}
\description{
Data of 11 DMUs with two inputs and one output.
}
\examples{
# Example. Replication of results in Ali and (1993, p.143).
data("Fried1993")
data_example <- read_data(Fried1993,
                          ni=2,
                          no=1)
result <- model_basic(data_example,
                      orientation="oo",
                      rts="vrs")
efficiencies(result)
targets(result)

}
\seealso{
\code{\link{read_data}}, \code{\link{model_basic}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
