% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_data}
\alias{read_data}
\title{read_data}
\usage{
read_data(datadea,
ni = NULL, no = NULL, dmus = 1, inputs = NULL, outputs = NULL, nc_inputs = NULL,
nc_outputs = NULL, nd_inputs = NULL, nd_outputs = NULL, ud_inputs = NULL, 
ud_outputs = NULL)
}
\arguments{
\item{datadea}{Data frame with DEA data.}

\item{ni}{Number of inputs, if inputs are in columns 2:(\code{ni} + 1) (if DMUs are in the first column) or 1:\code{ni} (no DMUs column).}

\item{no}{Number of outputs, if outputs are in columns (\code{ni} + 2):(\code{ni} + \code{no} + 1) (if DMUs are in the first column) or (\code{ni} + 1):(\code{ni} + \code{no}) (no DMUs column).
If not specified, DMUs are in the first column.}

\item{dmus}{Column (number or name) of DMUs (optional). If there is not any DMU column, then it must be \code{NULL}.}

\item{inputs}{Columns (numbers or names) of inputs (optional). It prevails over \code{ni}.}

\item{outputs}{Columns (numbers or names) of outputs (optional). It prevails over \code{no}.}

\item{nc_inputs}{A numeric vector containing non-controllable inputs.}

\item{nc_outputs}{A numeric vector containing non-controllable outputs.}

\item{nd_inputs}{A numeric vector containing non-discretionary inputs.}

\item{nd_outputs}{A numeric vector containing non-discretionary outputs.}

\item{ud_inputs}{A numeric vector containing undesirable (good) inputs.}

\item{ud_outputs}{A numeric vector containing undesirable (bad) outputs.}
}
\value{
An object of class \code{deadata}
}
\description{
This function creates, from a data frame, a \code{deadata} structure, which is as list with fields
\code{input}, \code{output}, \code{dmunames}, \code{nc_inputs}, \code{nc_outputs}, \code{nd_inputs}, \code{nd_outputs}.
}
\examples{
data("Coll_Blasco_2006")
data_example <- read_data(datadea = Coll_Blasco_2006,
                          ni = 2, 
                          no = 2)
# This is the same as:
data_example <- read_data(Coll_Blasco_2006,
                          dmus = 1,
                          inputs = 2:3, 
                          outputs = 4:5)
# If the first input is a non-controllable input:
data_example <- read_data(Coll_Blasco_2006,
                          dmus = 1,
                          inputs = 2:3,
                          outputs = 4:5, 
                          nc_inputs = 1)
# If the second output is a non-discretionary output:
data_example <- read_data(Coll_Blasco_2006,
                          dmus = 1, 
                          inputs = 2:3, 
                          outputs = 4:5, 
                          nd_outputs = 2)
# If the second input is a non-discretionary input and the second output is an undesirable:
data_example <- read_data(Coll_Blasco_2006,
                          dmus = 1, 
                          inputs = 2:3, 
                          outputs = 4:5, 
                          nd_inputs = 2, 
                          ud_outputs = 2)

}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
