%                               -*- Mode: Rd -*- 
% maketrylist.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:52 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Sun Nov 14 18:01:13 2004
% Update Count    : 21
% Status          : Unknown, Use with caution!
% 

\name{maketrylist}
\alias{maketrylist}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Creates the full trylist}

\description{For faster learning, a trylist is maintained as a lookup
  table for a given parent configuration of a node.}

\usage{
maketrylist(initnw,data,prior=jointprior(network(data)),timetrace=FALSE) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
 \item{initnw}{an object of class \code{\link{network}}, from which the
    search is started. } 
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
\item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{This procedure is included for illustrative purposes. For each
  node in the 
  network, all possible parent 
  configurations are created and learned. The result is called a
  trylist. To create the full trylist is very time-consuming,
  and a better choice is to maintain a trylist while searching and
  indeed this is automatically done. The trylist is given as output to
  all functions that call the learning procedure and can be given as an
  argument. 
}

\value{A list with one element per node in the network. In the list,
  element \emph{i} is a matrix with two columns: a string with the
  indices of the parent nodes, separated by ":", and a numeric with the
  log-likelihood contribution of the node given the parent
  configuration. Whenever learning is performed of a node given a parent
  configuration, the trylist is consulted to yield faster learning,
  especially useful when using \code{\link{autosearch}} or
  \code{\link{heuristic}}.
} 


\references{
  Further information about \bold{Deal} can be found at:\cr
  \url{http://www.math.aau.dk/novo/deal}.
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.aau.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.aau.dk}.
}

\seealso{ 
  \code{\link{networkfamily}},
  \code{\link{autosearch}}
  \code{\link{heuristic}}
  }


  \examples{
data(rats)
rats.nw <- network(rats)
rats.pr <- jointprior(rats.nw,12)
rats.nw <- getnetwork(learn(rats.nw,rats,rats.pr))
rats.tr <- maketrylist(rats.nw,rats,rats.pr)

rats.hi <- getnetwork(heuristic(rats.nw,rats,rats.pr,trylist=rats.tr))
}

\keyword{models}
