%                               -*- Mode: Rd -*- 
% perturb.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:54 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Thu Jul 24 14:48:02 2003
% Update Count    : 22
% Status          : Unknown, Use with caution!
% 

\name{perturb}
\alias{perturb}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Perturbs a network}

\description{Randomly insert/delete/turn arrows to obtain another network.
}

\usage{
perturb(nw,data,prior,degree=nw$n,trylist=vector("list",nw$n),
        nocalc=FALSE,timetrace=TRUE) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{network}, from which arrows are added/removed/turned.}
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{degree}{an integer, which gives the number of attempts to randomly
    insert/remove/turn an arrow.}
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{nocalc}{a logical. If \code{TRUE} no learning procedure is called, see eg. \code{\link{simulation}}.}
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{
  Given the initial network, a new network is constructed by randomly
  choosing an action: remove, turn, add. After the action is chosen, we
  choose randomly among all possibilities of that action. If there are
  no possibilites, the unchanged network is returned.}

\value{A list with two elements,
  \item{nw}{an object of class \code{\link{network}} with the generated network.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
set.seed(200)
data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit)
fit       <- learn(fit,rats,fit.prior)$nw
fit.new   <- perturb(fit,rats,fit.prior,degree=10)$nw

data(ksl)
ksl.nw    <- network(ksl)
ksl.rand  <- perturb(ksl.nw,nocalc=TRUE,degree=10)$nw 
plot(ksl.rand)
}

\keyword{iplot}
