% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.empty.R
\name{is.empty}
\alias{is.empty}
\title{Test the presence of empty (undeclared) missing values}
\usage{
is.empty(x)
}
\arguments{
\item{x}{A vector}
}
\value{
A logical vector.
}
\description{
Functions that indicate which elements are empty \code{NA} missing values, in
contrast to declared missing values.
}
\details{
All missing values, declared or undeclared, as stored as regular \code{NA}
values, therefore the base function \code{is_na()} does not differentiate
between them.

These functions are specifically adapted to objects of class \code{"declared"},
to return a truth value only for those elements that are completely missing
with no reason.
}
\examples{

x <- declared(
    c(1:2, -91),
    labels = c(Good = 1, Bad = 2, Missing = -91),
    na_values = -91
)

x

is.empty(x) # FALSE FALSE FALSE

x <- c(x, NA)

is.empty(x) # FALSE FALSE FALSE  TRUE

}
