% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delim_brewer.R
\name{delim_brewer}
\alias{delim_brewer}
\title{Customize Delimitation Colors}
\usage{
delim_brewer(delim, package = NULL, palette = NULL, seed = NULL)
}
\arguments{
\item{delim}{Output from \link{delim_join}.}

\item{package}{Package which contains color palettes. Available options are
"RColorBrewer", "viridisLite" or "randomcoloR".}

\item{palette}{A palette name. \link[RColorBrewer:ColorBrewer]{brewer.pal} for RColorBrewer
or \link[viridisLite:viridis.map]{viridis} for viridisLite options.}

\item{seed}{Integer. Number to initialize random number generator.}
}
\value{
A \code{character} vector of hexadecimal color codes.
}
\description{
\code{delim_brewer()} returns a set of colors created by interpolating or using
color palettes from \link[RColorBrewer:ColorBrewer]{RColorBrewer},
\link[viridisLite:viridis.map]{viridisLite} or \link[randomcoloR:distinctColorPalette]{randomcoloR}.
}
\details{
\code{delim_brewer()} interpolates over a color palette and returns a vector of random colors
whose length is equal to the sum of unique species delimitation partitions in \code{delim}.
For reproducibility, make sure to provide a \code{seed}. If not provided, \link[base:Sys.time]{Sys.time}
will be used as seed instead. One should also try different seeds to get best color combinations for plotting.
}
\examples{

# create a vector of colors
cols <- delim_brewer(geophagus_delims, package = "randomcoloR")

}
\author{
Rupert A. Collins, Pedro S. Bittencourt
}
