% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{iaepv2_adj}
\alias{iaepv2_adj}
\title{Adjusted Institutions and Elections Project Data (V2.0)}
\format{
An 8 column, 10648 row, \code{data.table} where each row is a
country-year:
\describe{
\item{cname}{Country name.}
\item{cowcode}{The numeric Correlates of War country code.}
\item{iso3}{The International Organization for Standardization (ISO) 3
character country code.}
\item{year}{Numeric year.}
\item{formalconstit}{Binary indicator if constitution exists.}
\item{ineffect}{Binary indicator if constitution was in effect on January 1
of the specified year.}
\item{timeineffect}{Numeric value specifying number of years the current
constitution has been in effect as of January 1.}
\item{timeineffect2}{Numeric value specifying number of consecutive years a
constitution has been in effect without interruptions as of January 1.}
}
}
\usage{
iaepv2_adj
}
\description{
A pre-processed and amended subset of the Institutions and Elections Project
Data (V2.0) dataset.
}
\details{
\subsection{About}{

This dataset was constructed after detecting numerous and egregious
inconsistencies in the official dataset. We discovered several
errors for the coding of constitutions and constitutional ages in the
original dataset. This subset contains manual fixes using multiple sources
for constitutional data.These corrections were carried out by Lisa Emmer
under guidance from Joshua Brinks and Thomas Parris. For additional
information regarding the official IAEP (V2) dataset refer to the
\href{https://havardhegre.files.wordpress.com/2015/06/users_manual_iaep.pdf}{user
manual.}

If you are hesitant to use our adjusted dataset, you might consider using
Constitutes' Chronology of Constitutional Events (CCE). You could construct
a constitutional stability counter with CCE data using counter functions
like Base R's \code{\link[=rle]{rle()}} or \link{data.table}'s \code{\link[data.table:rleid]{data.table::rleid()}}.
}

\subsection{Amendment References}{

Edits to the original IAEP (V2.0) dataset were determined by reviewing
several constitutional databases and news articles. Some are not listed
below, because the websites are no longer available, but the currently
available sources include:

\itemize{
\item \href{https://constitutionnet.org/}{Constitution Net}
\item \href{http://countrystudies.us/}{Country Studies}
\item \href{https://law.stanford.edu/}{Stanford Law}
\item \href{https://exit.al/}{Exit News}
\item \href{https://en.wikipedia.org/wiki/Main_Page}{Wikipedia}
\item \href{https://www.constituteproject.org}{Constitute}
\item \href{https://www.cia.gov/the-world-factbook/}{CIA World Factbook}
\item \href{https://gulfmigration.org/}{Gulf Labor Markets and Migration}
\item \href{https://uca.edu/politicalscience/dadm-project/}{Dynamic Analysis of Dispute Management (DADM) Project}
\item \href{https://home.heinonline.org/content/world-constitutions-illustrated/}{World Constitutions Illustrated}
\item \href{https://www.kas.de/de/home}{Konrad Adenauer Stiftung}
\item \href{https://www.nytimes.com}{The New York Times}
\item \href{https://china.usc.edu/}{The USC USA-China Institute}
\item \href{https://www.globalsecurity.org/}{Global Security}
\item \href{https://www.egypttoday.com}{Egypt Today}
\item \href{http://www.scielo.org.za}{SciElo South Africa}
\item \href{https://www.gambia.dk/}{Nijii}
\item \href{https://www.lawhubgambia.com/}{Law Hub Gambia}
\item \href{https://www.artsrn.ualberta.ca/amcdouga/Hist247/winter_2017/resources/}{University of Alberta}
\item \href{https://pdba.georgetown.edu}{Political Database of the Americas}
\item \href{https://www.loc.gov}{Library of Congress}
\item \href{https://www.servat.unibe.ch/icl/}{International Constitutional Law Countries}
\item \href{https://e-history.kz/en/}{Kazakhstan History Portal}
\item \href{https://www.cambridge.org}{Cambridge University Press}
\item \href{https://malawilii.org/}{Malawi Legal Information Institute}
\item \href{https://www.wipo.int/portal/en/index.html}{World Intellectual Property Organization}
\item \href{https://digitalcommons.law.uw.edu/}{University of Washington Law: Digital Commons}
\item \href{https://himalaya.socanth.cam.ac.uk}{Digital Himalaya}
\item \href{https://www.hathitrust.org/}{Hathi Trust Digital Library}
\item \href{https://www.ilo.org}{International Labour Organization}
\item \href{https://www.ifes.org/}{International Foundation for Electoral Systems}
\item \href{https://www.congreso.gob.pe/}{Congreso de la Republica}
\item \href{https://www.officialgazette.gov.ph/}{Official Gazette of the Republic of the Philippines}
\item \href{https://www.usaid.gov/}{U.S. Agency for International Aid}
\item \href{http://vietnamproject.archives.msu.edu/}{Michigan State University Vietnam Group Archives}
\item \href{https://www.marxists.org}{Marxist Internet Archive}
\item \href{http://www.sierra-leone.org}{Sierra Leone Web}
\item \href{https://www.gov.za/}{Government of South Africa}
\item \href{https://pkp.sfu.ca/ojs/}{Open Journal Systems}
\item \href{https://www.legislation.gov.uk}{UK Legislation}
\item \href{https://www.mfa.gov.tm/en}{Ministry of Foreign Affairs of Turkmenistan}
\item \href{https://www.statehouse.go.ug}{State House Uganda}
\item \href{https://u.ae/en/}{The United Arab Emirates' Government Portal}
\item \href{https://constitution.uz/en}{Constitution of the Republic of Uzbekistan}
\item \href{https://vietnamlawmagazine.vn}{Vietnam Law and Legal Forum}
\item \href{https://vietnamembassy-usa.org}{Embassy of the Socialist Republic of Vietnam}
}
}
}
\seealso{
The original dataset release was accompanied by a peer reviewed manuscript:

Wig, T., Hegre, H., & Regan, P. M. (2015). Updated data on institutions and elections
1960–2012: Presenting the IAEP dataset version 2.0. Research & Politics, 2(2).
\doi{10.1177/2053168015579120}.
}
\keyword{datasets}
