% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_lower_fun.R
\name{cut_lower_fun}
\alias{cut_lower_fun}
\alias{dendextend_cut_lower_fun}
\title{Cut a dendrogram - and run a function on the output}
\usage{
cut_lower_fun(dend, h, FUN = labels, warn = dendextend_options("warn"), ...)
}
\arguments{
\item{dend}{a dendrogram object.}

\item{h}{a scalar of height to cut the dend by.}

\item{FUN}{a function to run. (default is "labels")}

\item{warn}{logical (default from dendextend_options("warn") is FALSE).
Set if warning are to be issued, it is safer to keep this at TRUE,
but for keeping the noise down, the default is FALSE.
Should the user be warned if reverting to default?}

\item{...}{passed to FUN.}
}
\value{
A list with the output of running FUN on each of the 
sub dends derived from cutting "dend"
}
\description{
Cuts the dend at height h and returns a list with the FUN function
implemented on all the sub trees created by cut at height h.
This is used for creating a \link[dendextend]{cutree.dendrogram} function,
by using the \code{labels} function as FUN.

This is the Rcpp version of the function, offering a 10-60 times improvement
in speed (depending on the tree size it is used on).
}
\examples{

dend = as.dendrogram(hclust(dist(iris[1:4,-5])))
# this is really cool!
cut_lower_fun(dend, .4, labels)
lapply(cut(dend, h = .4)$lower, labels)   
cut_lower_fun(dend, .4, order.dendrogram)


\dontrun{
# library(dendextend)
library(dendextendRcpp)
dend_big = as.dendrogram(hclust(dist(iris[1:150,-5])))
library(microbenchmark)
microbenchmark(old_cut_lower_fun(dend_big,.1),
               dendextendRcpp::dendextendRcpp_cut_lower_fun(dend_big,.1),
               times = 100)
# about 7-15 times faster. It is faster the larger the tree is, and the lower h is.
}

}
\author{
Tal Galili
}
\seealso{
\code{\link{labels}}, \code{\link{dendrogram}},
\link[dendextend]{cutree.dendrogram}
}

