% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{angle2slope}
\alias{angle2slope}
\title{Angle to slope}
\usage{
angle2slope(angle, angleUnit = c("deg", "rad"))
}
\arguments{
\item{angle}{numeric vector of angle to be converted to slope.}

\item{angleUnit}{The unit of \code{angle}. Either \code{"deg"}, \code{"rad"}. Default is \code{"deg"}.}
}
\value{
Returns a vector of slope values.
}
\description{
Converts angle values to  slope values.
}
\examples{
angle2slope(10)
angle2slope(angle = 45)
angle2slope(angle = 50, angleUnit = "deg")
angle2slope(1.047198, "rad")
angle2slope(0.2617994, angleUnit = "rad")
}
\seealso{
\code{\link{slope2angle}}, the the complement of \code{angle2slope}.
}
