% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optishrink.R
\name{optishrink}
\alias{optishrink}
\title{Optimal Shrinkage}
\usage{
optishrink(X, sigma = NA, center = "TRUE", method = c("ASYMPT", "LN"),
  loss = c("Frobenius", "Operator", "Nuclear"), k = NA)
}
\arguments{
\item{X}{a data frame or a matrix with numeric entries}

\item{sigma}{integer, standard deviation of the Gaussian noise. By default sigma is estimated using the estim_sigma function}

\item{center}{boolean, to center the data. By default "TRUE"}

\item{method}{asymptotic framework used either low noise LN or ASYMPT. By default ASYMPT}

\item{loss}{by default Frobenius only if method = "ASYMPT"}

\item{k}{integer, specifying the rank of the signal only if method = "LN". By default k is estimated using the estim_ncp function of the FactoMineR package}
}
\value{
mu.hat the estimator of the signal

nb.eigen the number of non-zero singular values

singval the singular values of the estimator

low.rank the results of the SVD of the estimator
}
\description{
This function estimates a low-rank signal from Gaussian noisy data using the Optimal Shrinker of the singular values. 
More precisely, in an asymptotic framework, the estimator which applies a non-linear transformation of the singular values is the closest to the underlying signal in term of mean squared error. 
Two asymptotic frameworks are considered: one where both the number of rows and the number of columns are fixed while the noise variance tends to zero (Low Noise) and one where both the number of rows and of columns tend to infinity (ASYMPT) while the rank of the matrix stays fixed. In this latter, an optimal shrinker is given according to different norm losses (Frobenius, Operator, Nuclear).
}
\details{
In the low noise (LN) asymptotic framework, the estimator applies the following transformation on the first k singular values dl  = dl *(dl^2-sigma^2)/dl^2. Thus, it requires providing both the rank k and a value for sigma.  Concerning the rank k, different methods are available in the litterature and if by default the user does not provide any value, we use of the function estim_ncp of the FactoMineR package with the option GCV (see ?estim_ncp).
The other asymptotic framework (ASYMPT) only requires providing sigma. optishrink automatically estimates the rank of the signal. Its value is given in the output nb.eigen corresponding to the number of non-zero eigenvalues. 
The estimated low rank matrix is given in the output mu.hat.
}
\examples{
Xsim <- LRsim(200, 500, 10, 2)
opti.ln <- optishrink(Xsim$X, method = "LN", k = 10)
opti.asympt <- optishrink(Xsim$X, method = "ASYMPT")

Xsim <- LRsim(200, 500, 100, 1)
truesigma <- 1/(1*sqrt(200*500))
opti.asympt <- optishrink(Xsim$X, method = "ASYMPT", sigma = truesigma)
opti.asympt$nb.eigen
}
\references{
Gavish, M & Donoho, D. L. (2014). Optimal Shrinkage of Singular Values.

Verbanck, M., Husson, F. & Josse, J. (2015). Regularised PCA to denoise and visualise data. Statistics & Computing. 25 (2), 471-486
}
\seealso{
\code{\link{estim_sigma}}

\code{\link{LRsim}}
}

