% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual.R
\name{correct_failures}
\alias{correct_failures}
\title{Manually correct failures after automatic trim detection}
\usage{
correct_failures(dp.trimmed)
}
\arguments{
\item{dp.trimmed}{A list of dp objects, trimmed, with the report
embedded ("rreport = TRUE").}
}
\value{
A list of trimmed profiles, including both automatic and
  manual trimming.
}
\description{
This function will take a list of trimmed dp objects (a result of
dptriml or dptriml_s function) and interactively ask the user to
assign starting/ending points manually. Follow-up to automatic
trim functions or to be used manually, will display a plot with the
density profiles for each failure in trim detection sequentially.
The plot title will display whether you are selection start or end
positions. Use your mouse to select starting/ending point on the
plot, your selection will then be displayed on the plot. Use keys
y/n to confirm selection, pressing n will restart the selection
process. The selection can be repeated once after pressing n, next
n will stop the process and it has to be restarted manually. Will
return a complete list, both with the non-failed automatically
trimmed dp objects and those corrected manually. The automatic
trim functions should be called with the option
"rreport = TRUE", which embeds a trimming report when
returning the list of trimmed dp objects.
}
\examples{
## load all dp files
\donttest{
dp.list <- dpload(dp.directory = system.file("extdata", package = "densitr"))
## trim the list
dp.trimmed <- dptriml(dp.list, rreport = TRUE)
## manually correct the failures
dp.corrected <- correct_failures(dp.trimmed)
}
}
\seealso{
dptrim, dptriml, manual_trim_detect
}
