% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{dpdetect_e}
\alias{dpdetect_e}
\title{Detect measurement ending point automatically using changepoint
segmentation}
\usage{
dpdetect_e(dp, cutoff.sd = 1, return.plot = FALSE)
}
\arguments{
\item{dp}{A dp object, see dpload.}

\item{cutoff.sd}{How many standard deviations for the cutoff limit?}

\item{return.plot}{If true, will return a plot displaying segment
detection for the current dp file.}
}
\value{
Either a row number where the actual measurement ends or
  a plot, displaying changepoint segmentation and set limits.
}
\description{
The opposite of the dpdetect_s, it will check the mean values
of the last four segments and compare them to the cutoff limit.
Will give a warning if end not detected, which is expected on
measurements where the needle did not exit the tree on the opposite
side of the tree. See \code{return.plot = TRUE} to display the
actual process. The function is called on a dp object and returns
either a row number of the measurement ending or a plot displaying
the segmentation and detection. The sensitivity can be adjusted
using the cutoff.sd parameter, which is an indicator on how many
standard deviations the segment mean value can be before cutting it
off.
}
\examples{
## load a single file
dp  <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## get ending point
start <- dpdetect_e(dp)
## plot the end detection
\donttest{
dpdetect_e(dp, return.plot = TRUE)
}
}
\seealso{
dpdetect_s, dptrim, dptriml, dptrim_s, dptriml_s
}
