% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{get.dmi.tens}
\alias{get.dmi.tens}
\title{Faster implementation to obtain the tensor of the evaluations of the
derivatives of the moment functions at each observation.}
\usage{
get.dmi.tens(data, beta, t, hp, inst.func.evals = NULL)
}
\arguments{
\item{data}{Data frame.}

\item{beta}{Vector of coefficients.}

\item{t}{Time point of interest. Also allowed to
be a vector of time points (used in estimating the model under assumed time-
independent coefficients).}

\item{hp}{List of hyperparameters.}

\item{inst.func.evals}{Precomputed matrix of instrumental function
evaluations. Defaults is \code{inst.func.evals = NULL}, in which case the
evaluations will be done inside this function.}
}
\description{
This function provides a faster implementation of obtaining the
evaluations of the derivative of the moment functions at each observation
(wrt the previous implementation using 'dm.comp' and 'dm.R'). Used in the
function G.hat.R
}
