% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-table.R
\name{oway_tables}
\alias{oway_tables}
\alias{tway_tables}
\title{Multiple One & Two Way Tables}
\usage{
oway_tables(data)

tway_tables(data)
}
\arguments{
\item{data}{a data frame}
}
\description{
\code{oway_tables} creates multiple one way tables by creating
a frequency table for each categorical variable in a data frame.
\code{tway_tables} creates multiple two way tables by creating a cross
table for each unique pair of categorical variables in a data frame.
}
\details{
\code{oway_tables} is a extension of the \code{freq_table}
function. It creates a frequency table for each categorical variable in the
dataframe. \code{tway_tables} is a extension of the \code{cross_table}
function. It creates a two way table for each unique pair of categorical
variables in the dataframe.
}
\examples{
mt <- mtcars
mt[, c(2, 8, 9)] <- lapply(mt[, c(2, 8, 9)], factor)
# multiple one way tables
oway_tables(mt)

# multiple two way tables
tway_tables(mt)
}
\seealso{
\code{link{freq_table}} \code{link{cross_table}}
}
