% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d.low.R
\name{d.low}
\alias{d.low}
\title{Low  values are desirable}
\usage{
d.low(x, cut1, cut2, des.min = 0, des.max = 1, scale = 1)
}
\arguments{
\item{x}{Vector of numeric or integer values.}

\item{cut1,cut2}{Values of the original data that define where the
desirability function changes.}

\item{des.min,des.max}{Minimum and maximum desirability values. Defaults to
zero and one, respectively.}

\item{scale}{Controls how steeply the function increases or decreases.}
}
\value{
Numeric vector of desirability values.
}
\description{
Maps a numeric variable to a 0-1 scale such that low values are
desirable.
}
\details{
Values less than \code{cut1} will have a high desirability. Values
greater than \code{cut2} will have a low desirability. Values between
\code{cut1} and \code{cut2} will have intermediate values.
}
\examples{
set.seed(1)
x <- rnorm(1000, mean=100, sd =5) # generate data
d <- d.low(x, cut1=90, cut2=110, scale=1)

# plot data
hist(x, breaks=30)
# add line
des.line(x, "d.low", des.args=c(cut1=90, cut2=110, scale=1))

hist(x, breaks=30)
des.line(x, "d.low", des.args=c(cut1=90, cut2=110, des.min=0.1,
des.max=0.95, scale=1.5))
}
\seealso{
\code{\link{d.high}},  \code{\link{d.4pl}}
}

