% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{campbell_74}
\alias{campbell_74}
\title{Campbell et al. equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\usage{
campbell_74
}
\description{
Campbell, A., Frazer, B. D., Gilbert, N. G. A. P., Gutierrez, A. P., & Mackauer, M. (1974).
Temperature requirements of some aphids and their parasites. Journal of applied ecology, 431-438. <doi:10.2307/2402197>
}
\details{
Equation:
\deqn{rT = aa + bb * T}{%
      rT = aa + bb * T}

where rT is the development rate, T the temperature, bb the slope, and aa
the point at which the line crosses the rT axis when T = 0.
}
\keyword{datasets}
