% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devianlm_stats.R
\name{get_devianlm_threshold}
\alias{get_devianlm_threshold}
\title{get_devianlm_threshold : Compute threshold using Monte Carlo simulations}
\usage{
get_devianlm_threshold(
  x,
  n_sims = 50000,
  nthreads = detectCores() - 1,
  alpha = 0.95
)
}
\arguments{
\item{x}{either a numeric variable or several numeric variables
(explanatory variables) concatenated in a data frame.}

\item{n_sims}{optional value which is the number of simulations, is set to 50.000 by default.}

\item{nthreads}{optional value which is the number of CPU cores to use, is set to "number of CPU cores - 1"
by default.}

\item{alpha}{quantile of interest, is set to 0.95 by default.}
}
\value{
Numeric value. \item{threshold}{The quantile of order 1-alpha of the distribution of the maximum of the absolute of the studentized residuals (depending on the design matrix) is computed via Monte-Carlo simulations (with n_sims simulations).}
}
\description{
This package determines whether the maximum of the absolute values
of the studentized residuals of a Gaussian regression is abnormally high.
The distribution of the maximum of the absolute of the studentized residuals
(depending on the design matrix) is computed via Monte-Carlo simulations (with n_sims simulations).
}
