% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_selection.R
\name{get_responses}
\alias{get_responses}
\title{Selecting data}
\usage{
get_responses(
  dataSrc,
  predicate = NULL,
  columns = c("person_id", "item_id", "item_score")
)
}
\arguments{
\item{dataSrc}{a connection to a dexter database, a matrix, or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{an expression to select data on}

\item{columns}{the columns you wish to select, can include any column in the project, see: \code{\link{get_variables}}}
}
\value{
a data.frame of responses
}
\description{
Extract data from a dexter database
}
\details{
Many functions in Dexter accept a data source and a predicate. Predicates are extremely flexible 
but they have a few limitations because they work on the individual response level. It is therefore not possible
for example, to remove complete person cases from an analysis based on responses to a single item 
by using just a predicate expression.

For such cases, Dexter supports selecting the data and manipulating it before passing it back to a Dexter function 
or possibly doing something else with it. The following example will hopefully clarify this.
}
\examples{
\donttest{
\dontrun{
# goal: fit the extended nominal response model using only persons 
# without any missing responses
library(dplyr)

# the following would not work since it will omit only the missing 
# responses, not the persons; which is not what we want in this case
wrong = fit_enorm(db, response != 'NA')

# to select on an aggregate level, we need to gather the data and 
# manipulate it ourselves
data = get_responses(db, 
   columns=c('person_id','item_id','item_score','response')) |>
   group_by(person_id) |>
   mutate(any_missing = any(response=='NA')) |>
   filter(!any_missing)

correct = fit_enorm(data)

}}
}
