% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dhReg.R
\name{dhr}
\alias{dhr}
\title{Dynamic Harmonic Regression}
\usage{
dhr(Data, Range, XREG = NULL, Frequency, Criteria = "aicc", maxp = 5,
  maxq = 5, maxd = 5)
}
\arguments{
\item{Data}{a time series data}

\item{Range}{Range of k in fourier series}

\item{XREG}{independent variable if any}

\item{Frequency}{seasonal frequency(can be multiple)}

\item{Criteria}{can be "aicc", "aic", "bic"}

\item{maxp}{maximum value of Auto regressive term in auto.arima}

\item{maxq}{maximum value of Moving average term in auto.arima}

\item{maxd}{maximum value of integrated term in auto.arima}
}
\value{
summary of Dynamic harmonic regression model
}
\description{
Building model for time series data with multiple seasonality using Dynamic Harmonic Regression
}
\examples{
\donttest{
Data1 <- runif(runif(200,100,1000)) #To generate random number for example
Data_ts <- ts(Data1)
M <- dhr(Data=Data_ts,XREG=NULL,Range=list(1:2,1),Frequency=c(24,168),Criteria="aicc")
}
}
