% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{Get National Library Metadata for identifiers}
\usage{
get_metadata(dhlabids = NULL, urns = NULL)
}
\arguments{
\item{dhlabids}{A vector of dhlabids (default is NULL). When provided, the function will use dhlabids to fetch metadata.}

\item{urns}{A vector of National Library URNs (default is NULL). When provided, the function will use URNs to fetch metadata.}
}
\value{
A dataframe containing the National Library metadata for the specified objects.
}
\description{
This function retrieves metadata for objects from the National Library API based on either a vector of dhlabids or a vector of National Library URNs.
}
\examples{
  urns_example <- c("URN:NBN:no-nb_digibok_2008051404065", "URN:NBN:no-nb_digibok_2010092120011")
  metadata_urns <- get_metadata(urns = urns_example)
}
