% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagstats.R
\name{diagstats}
\alias{diagstats}
\title{Calculate statistical measures of test performance for objects of
class \code{diagmeta}}
\usage{
diagstats(x, cutoff = x$optcut, prevalence = NA, level = 0.95)
}
\arguments{
\item{x}{An object of class \code{diagmeta}}

\item{cutoff}{A numeric or vector with cutoff value(s)}

\item{prevalence}{A numeric or vector with the prevalence(s)}

\item{level}{The level used to calculate confidence intervals}
}
\value{
A data frame of class "diagstats" with the following
  variables:

\item{cutoff}{As defined above.}
\item{Sens}{Model-based estimate of the sensitivity for given
  cutoff}
\item{seSens}{Standard error of sensitivity}
\item{lower.Sens, upper.Sens}{Lower and upper confidence limits of
  the sensitivity}
\item{Spec}{Model-based estimate of the specificity for given
  cutoff}
\item{seSpec}{Standard error of sensitivity}
\item{lower.Spec, upper.Spec}{Lower and upper confidence limits of
  the specificity}
\item{prevalence}{As defined above.}
\item{PPV}{Positive predictive value, given the cutoff}
\item{NPV}{Negative predictive value, given the cutoff}
\item{PD}{Probability of disease if the given "cutoff" was observed
  as the measurement for an individual}
\item{dens.nondiseased}{Value of the model-based density function at the
  given cutoff for non-diseased individuals}
\item{dens.diseased}{Value of the model-based density function at the
  given cutoff for diseased individuals}
}
\description{
The user can provide cutoffs and prevalences to calculate
sensitivities and specificities (with confidence intervals),
positive predictive values (PPV), negative predictive values (NPV),
and probabilities of disease (PD) for a \code{diagmeta} object.
}
\examples{

# FENO dataset
#
data(Schneider2017)

diag1 <- diagmeta(tpos, fpos, tneg, fneg, cutpoint,
                  studlab = paste(author, year, group),
                  data = Schneider2017, 
                  model = "DIDS", log.cutoff = TRUE)

# Values at the optimal cutoff
#
diagstats(diag1)

# Values for prevalence 10\% at cutoffs 25 and 50
#
diagstats(diag1, c(25, 50), 0.10)

}
\seealso{
\code{\link{diagmeta}} \code{\link{print.diagstats}}
}
\author{
Gerta Rücker \email{ruecker@imbi.uni-freiburg.de}, Srinath
  Kolampally \email{kolampal@imbi.uni-freiburg.de}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}
}
