% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phone.R
\name{dialr-phone}
\alias{dialr-phone}
\alias{phone}
\alias{phone_reparse}
\alias{is.phone}
\alias{print.phone}
\alias{format.phone}
\alias{as.character.phone}
\title{Phone number parsing and formatting}
\usage{
phone(x, region)

phone_reparse(x)

is.phone(x)

\method{print}{phone}(x, n = 10, ...)

\method{format}{phone}(
  x,
  format = c("E164", "NATIONAL", "INTERNATIONAL", "RFC3966"),
  home = NULL,
  clean = TRUE,
  strict = FALSE,
  ...
)

\method{as.character}{phone}(x, raw = TRUE, ...)
}
\arguments{
\item{x}{A character vector of phone numbers.}

\item{region}{A character vector of \link[=dialr-region]{ISO country codes} with
the default region for each phone number in \code{x}. A \code{region} vector of
length 1 will be recycled to the length of \code{x}.

If \code{NA} or \code{""}, numbers written in international format (with a leading
\code{+}) will be parsed without a default region.}

\item{n}{Number of elements to print.}

\item{...}{Additional arguments for specific methods.}

\item{format}{Phone number format to use from one of four standards:
\itemize{
\item \code{"E164"}: general format for international telephone numbers from \href{https://en.wikipedia.org/wiki/E.164}{ITU-T Recommendation E.164}
\item \code{"NATIONAL"}: national notation from \href{https://en.wikipedia.org/wiki/E.123}{ITU-T Recommendation E.123}
\item \code{"INTERNATIONAL"}: international notation from \href{https://en.wikipedia.org/wiki/E.123}{ITU-T Recommendation E.123}
\item \code{"RFC3966"}: "tel" URI syntax from the IETF \href{https://datatracker.ietf.org/doc/rfc3966/}{tel URI for Telephone Numbers}
}

See notes from the \href{https://static.javadoc.io/com.googlecode.libphonenumber/libphonenumber/8.10.10/index.html?com/google/i18n/phonenumbers/PhoneNumberUtil.PhoneNumberFormat.html}{libphonenumber javadocs}
for more details.

\code{format} defaults to \code{"E164"}. The default can be set in option
\code{dialr.format}.}

\item{home}{\link[=dialr-region]{ISO country code} for home region. If provided,
numbers will be formatted for dialing from the home region.}

\item{clean}{Should non-numeric characters be removed? If \code{TRUE}, keeps
numbers and leading \code{"+"}.}

\item{strict}{Should invalid phone numbers be removed? If \code{TRUE}, invalid
phone numbers are replaced with \code{NA}.}

\item{raw}{If \code{TRUE}, the raw phone number is returned. Otherwise elements
are cleaned with \code{format()}.}
}
\description{
A phone vector stores phone numbers parsed with libphonenumber for formatting
and further processing.
}
\details{
libphonenumber defines the \code{PhoneNumberUtil} class, with a set of functions
for extracting information from and performing processing on a parsed
\code{Phonenumber} object. A text phone number must be parsed before any other
operations (e.g. checking phone number validity, formatting) can be
performed. When parsing a phone number a \link[=dialr-region]{"default region"} is
required to determine the processing context for non-international numbers.

A phone vector stores the raw phone number, the default region and a java
\code{Phonenumber} object for each element. The java object is cached so should
persist between R sessions. In case of issues, use \code{phone_reparse()} to
recreate the phone vector from the original phone number and region.

Phone number parsing functions display a progress bar in interactive sessions
by default. This can be disabled by setting option \code{dialr.show_progress} to
\code{FALSE}.
}
\section{libphonenumber reference}{


\code{phone()}: Phone numbers are parsed using
\code{PhoneNumberUtil.parseAndKeepRawInput()}. A phone vector stores the
returned \code{Phonenumber.PhoneNumber} object alongside the original raw text
and default region for later reference.

\code{format()}: \code{PhoneNumberUtil.format()} by default, or
\code{PhoneNumberUtil.formatOutOfCountryCallingNumber()} if \code{home} is provided.
}

\examples{
  # Create a phone vector
  x <- phone(c(0, 0123, "0412 345 678", "61412987654", "03 9123 4567", "+12015550123"), "AU")
  
  is.phone(x)
  print(x)
  as.character(x)
  format(x)
  format(x, home = "AU")
  
  # Parse international number with no default region
  phone("+61412345678", NA)
  
  # Will fail to parse if number is not in international format
  phone("0412345678", NA)
  
  # A combination can be used
  phone(c("+61412345678", "0412345678"), c(NA, "AU"))
}
\seealso{
Other phone functions: 
\code{\link{dialr-example}},
\code{\link{dialr-match}},
\code{\link{dialr-region}},
\code{\link{dialr-type}},
\code{\link{dialr-valid}},
\code{\link{dialr}}
}
\concept{phone functions}
