% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diat_findAcronyms.R
\encoding{UTF-8}
\name{diat_findAcronyms}
\alias{diat_findAcronyms}
\title{Search species' names or acronyms for diatoms}
\usage{
diat_findAcronyms(species_df, maxDistTaxa = 2, resultsPath)
}
\arguments{
\item{species_df}{The data frame with your species data. Species as rows, Samples as columns. If empty, a dialog box will prompt to import a CSV file}

\item{maxDistTaxa}{Integer. Number of characters that can differ in the species' names when compared to the internal database's name in the heuristic search. Default = 2}

\item{resultsPath}{String. Path to the output folder. If none specified (default), a dialog box will prompt to select it}
}
\description{
This function conducts both an exact and an heuristic search of the species' names and tries to convert it to its acronym in the internal database. If acronyms are already present in the input data, it attempts to update them to the latest taxonomy.
The input file for the package is a dataframe or an external CSV file. Species should be listed as rows, with species' names in column 1 (column name should be "species")
If the input data contains a column named "acronym", the package will use that column to match species with their ecological values. This is more accurate than the
heuristic search of species' names.
The other columns (samples) have to contain the abundance of each species (relative or absolute) in each sample.
The first row of the file has to contain the headers with the sample names. Remember that a column named "species" is mandatory, containing the species' names
If a dataframe is not specified as a parameter (species_df), the package will show a dialog box to search for the CSV file
A second dialog box will help set up an Output folder, where all outputs from the package will be exported to (dataframes, CSV files, plots in PDF)


Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi.org/10.1016/j.ecolind.2019.105951
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
