% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/did_imputation.R
\name{did_imputation}
\alias{did_imputation}
\title{Borusyak, Jaravel, and Spiess (2021) Estimator}
\usage{
did_imputation(
  data,
  yname,
  gname,
  tname,
  idname,
  first_stage = NULL,
  weights = NULL,
  wtr = NULL,
  horizon = NULL,
  pretrends = NULL
)
}
\arguments{
\item{data}{A \code{data.frame}}

\item{yname}{String. Variable name for outcome.}

\item{gname}{String. Variable name for unit-specific date of treatment
(never-treated should be zero or \code{NA})}

\item{tname}{String. Variable name for calendar period}

\item{idname}{String. Variable name for unique unit id}

\item{first_stage}{Formula for Y(0).
Formula following \code{\link[fixest:feols]{fixest::feols}}.
Fixed effects specified after "\code{|}".
If not specified, then just unit and time fixed effects will be used.}

\item{weights}{String. Variable name for estimation weights of observations.
This is used in estimating Y(0) and also augments treatment effect weights.}

\item{wtr}{Character vector of treatment weight names
(see horizon for standard static and event-study weights)}

\item{horizon}{Integer vector of event_time or \code{TRUE}. This only applies if \code{wtr} is left
as \code{NULL}. if specified, weighted averages/sums of treatment effects will be
reported for each of these horizons separately (i.e. tau0 for the treatment
period, tau1 for one period after treatment, etc.).
If \code{TRUE}, all horizons are used.
If \code{wtr} and \code{horizon} are null, then the static treatment effect is calculated.}

\item{pretrends}{Integer vector or \code{TRUE}. Which pretrends to estimate.
If \code{TRUE}, all \code{pretrends} are used.}
}
\value{
A \code{data.frame} containing treatment effect term, estimate, standard
error and confidence interval. This is in \code{tidy} format.
}
\description{
Treatment effect estimation and pre-trend testing in staggered adoption
diff-in-diff designs with an imputation approach of Borusyak, Jaravel, and
Spiess (2021)
}
\details{
The imputation-based estimator is a method of calculating treatment effects
in a difference-in-differences framework. The method estimates a model for
Y(0) using untreated/not-yet-treated observations and predicts Y(0) for the
treated observations hat(Y_it(0)). The difference between treated and
predicted untreated outcomes Y_it(1) - hat(Y_it(0)) serves as an estimate
for the treatment effect for unit i in period t. These are then averaged to
form average treatment effects for groups of {it}.
}
\section{Examples}{


Load example dataset which has two treatment groups and homogeneous treatment effects\if{html}{\out{<div class="r">}}\preformatted{# Load Example Dataset
data("df_hom", package="did2s")
}\if{html}{\out{</div>}}
\subsection{Static TWFE}{

You can run a static TWFE fixed effect model for a simple treatment indicator\if{html}{\out{<div class="r">}}\preformatted{did_imputation(data = df_hom, yname = "dep_var", gname = "g",
               tname = "year", idname = "unit")
#> # A tibble: 1 × 5
#>   term  estimate std.error conf.low conf.high
#>   <chr>    <dbl>     <dbl>    <dbl>     <dbl>
#> 1 treat     2.02    0.0324     1.96      2.09
}\if{html}{\out{</div>}}
}

\subsection{Event Study}{

Or you can use relative-treatment indicators to estimate an event study estimate\if{html}{\out{<div class="r">}}\preformatted{did_imputation(data = df_hom, yname = "dep_var", gname = "g",
               tname = "year", idname = "unit", horizon=TRUE)
#> # A tibble: 21 × 5
#>    term  estimate std.error conf.low conf.high
#>    <chr>    <dbl>     <dbl>    <dbl>     <dbl>
#>  1 0         2.12    0.0737     1.97      2.26
#>  2 1         1.86    0.0841     1.69      2.02
#>  3 2         1.99    0.0810     1.83      2.15
#>  4 3         2.00    0.0855     1.84      2.17
#>  5 4         1.95    0.0856     1.78      2.12
#>  6 5         2.04    0.0835     1.87      2.20
#>  7 6         2.03    0.0807     1.87      2.19
#>  8 7         2.03    0.0865     1.86      2.19
#>  9 8         1.98    0.0826     1.81      2.14
#> 10 9         2.12    0.0842     1.96      2.29
#> # … with 11 more rows
}\if{html}{\out{</div>}}
}

\subsection{Example from Cheng and Hoekstra (2013)}{

Here's an example using data from Cheng and Hoekstra (2013)\if{html}{\out{<div class="r">}}\preformatted{# Castle Data
castle <- haven::read_dta("https://github.com/scunning1975/mixtape/raw/master/castle.dta")

did_imputation(data = castle, yname = "l_homicide", gname = "effyear",
               first_stage = ~ 0 | sid + year,
               tname = "year", idname = "sid")
#> # A tibble: 1 × 5
#>   term  estimate std.error conf.low conf.high
#>   <chr>    <dbl>     <dbl>    <dbl>     <dbl>
#> 1 treat   0.0798    0.0531  -0.0243     0.184
}\if{html}{\out{</div>}}
}
}

