% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_mean.R
\name{plot_time_mean}
\alias{plot_time_mean}
\title{Plot time curve of average EEG signal with confidence interval}
\usage{
plot_time_mean(
  data,
  FS = 250,
  t0 = 1,
  color = "red",
  fill = "lightsalmon",
  transp = 0.4,
  y_limits = NULL,
  label_0ms = "stimulus",
  label_offset = c(0, 0)
)
}
\arguments{
\item{data}{A data frame, tibble or a database table with input data to plot. It should be an output from \code{\link{compute_mean}} function or an object with the same structure, containing columns: \code{time} with labels of time points and \code{average, ci_low, ci_up} with values of average signal and lower and upper CI bounds.}

\item{FS}{The sampling frequency. Default value is 250 Hz.}

\item{t0}{Index of the zero time point, i.e. point, where 0 ms should be marked (most often time of the stimulus or time of the response).}

\item{color}{The color of line. Default value is \code{red}. The argument accepts standard R color names or hex codes.}

\item{fill}{The color of CI bound, default value is \code{lightsalmon}. The argument accepts standard R color names or hex codes.}

\item{transp}{A numeric value between 0 and 1 controlling the transparency of the confidence ribbon (corresponding to \code{alpha} parameter in \link[ggplot2]{geom_ribbon} function).}

\item{y_limits}{A numeric vector of length two, specifying the minimum and maximum y-axis limits. Defaults to \code{NULL}for plot limits determined according to input data.}

\item{label_0ms}{Character string for the annotation label at the 0ms mark. Default is \code{"stimulus"}.}

\item{label_offset}{A numeric vector of length two to offset the stimulus label. The first value indicates a horizontal shift, the second a vertical one. Default is \code{c(0,0)} for no shift.}
}
\value{
A \code{ggplot} object showing the time course of the average EEG signal with pointwise confidence intervals for chosen sensor.
}
\description{
Plot a time curve of the average EEG signal amplitude together with pointwise confidence intervals (CIs).
}
\details{
The output in the form of a ggplot object allows to easily edit the result image properties. For interactive version of plot see \link{interactive_waveforms} function.
}
\examples{
# Plot average signal with CI bounds for subject 2 from the sensor E65
# excluding outlier epochs 14 and 15

# a) preparing data
# a1) extract required data
edata <- epochdata |>
dplyr::filter(subject == 2 & sensor == "E65" & epoch \%in\% 1:13)
# a2) baseline correction
data_base <- baseline_correction(edata, baseline_range = 1:10)
# a3) average computing
data_mean <- compute_mean(data_base, amplitude = "signal_base", subject = 2, channel = "E65",
 type = "point")
# b) plotting the average line with default settings
plot_time_mean(data = data_mean, t0 = 10)
}
