% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulaNLR.R
\name{formulaNLR}
\alias{formulaNLR}
\title{Formula for non-linear regression DIF model.}
\usage{
formulaNLR(model, constraints = NULL, type = "all", parameterization = "classic",
outcome)
}
\arguments{
\item{model}{character: generalized logistic regression model for which starting values should be
estimated. See \strong{Details}.}

\item{constraints}{character: which parameters should be the same for both groups. Possible values
are any combinations of parameters \code{"a"}, \code{"b"}, \code{"c"}, and \code{"d"}. Default value
is \code{NULL}. See \strong{Details}.}

\item{type}{character: type of DIF to be tested. Possible values are \code{"all"} for detecting
difference in any parameter (default), \code{"udif"} for uniform DIF only (i.e., difference in
difficulty parameter \code{"b"}), \code{"nudif"} for non-uniform DIF only (i.e., difference in
discrimination parameter \code{"a"}), \code{"both"} for uniform and non-uniform DIF (i.e.,
difference in parameters \code{"a"} and \code{"b"}), or combination of parameters \code{"a"},
\code{"b"}, \code{"c"}, and \code{"d"}. Can be specified as a single value (for all items) or as
an item-specific vector.}

\item{parameterization}{character: parameterization of regression
coefficients. Possible options are \code{"classic"} (IRT parameterization),
\code{"alternative"} (default) and \code{"logistic"} (logistic regression).
See \strong{Details}.}

\item{outcome}{character: name of outcome to be printed in formula. If not specified \code{"y"} is used.}
}
\value{
A list of two models. Both includes formula, parameters to be estimated and their lower and upper constraints.
}
\description{
Function returns the formula of the non-linear regression DIF model
based on model specification and DIF type to be tested.
}
\details{
The unconstrained form of 4PL generalized logistic regression model for probability of correct
answer (i.e., \eqn{y = 1}) is
\deqn{P(y = 1) = (c + cDif*g) + (d + dDif*g - c - cDif*g)/(1 + exp(-(a + aDif*g)*(x - b - bDif*g))), }
where \eqn{x} is by default standardized total score (also called Z-score) and \eqn{g} is a group membership.
Parameters \eqn{a}, \eqn{b}, \eqn{c}, and \eqn{d} are discrimination, difficulty, guessing, and inattention.
Terms \eqn{aDif}, \eqn{bDif}, \eqn{cDif}, and \eqn{dDif} then represent differences between two groups
(reference and focal) in relevant parameters.

The \code{model} argument offers several predefined models. The options are as follows:
\code{Rasch} for 1PL model with discrimination parameter fixed on value 1 for both groups,
\code{1PL} for 1PL model with discrimination parameter fixed for both groups,
\code{2PL} for logistic regression model,
\code{3PLcg} for 3PL model with fixed guessing for both groups,
\code{3PLdg} for 3PL model with fixed inattention for both groups,
\code{3PLc} (alternatively also \code{3PL}) for 3PL regression model with guessing parameter,
\code{3PLd} for 3PL model with inattention parameter,
\code{4PLcgdg} for 4PL model with fixed guessing and inattention parameter for both groups,
\code{4PLcgd} (alternatively also \code{4PLd}) for 4PL model with fixed guessing for both groups,
\code{4PLcdg} (alternatively also \code{4PLc}) for 4PL model with fixed inattention for both groups,
or \code{4PL} for 4PL model.

Three possible parameterization can be specified in \code{"parameterization"} argument: \code{"classic"}
returns IRT parameters of reference group and differences in these parameters between reference and focal group.
\code{"alternative"} returns IRT parameters of reference group, the differences in parameters \code{"a"} and
\code{"b"} between two groups and parameters \code{"c"} and \code{"d"} for focal group.
\code{"logistic"} returns parameters in logistic regression parameterization.
}
\examples{
# 3PL model with the same guessing for both groups
# to test both types of DIF
formulaNLR(model = "3PLcg", type = "both")

# 4PL model with the same guessing and inattention
# to test uniform DIF
formulaNLR(model = "4PLcgdg", type = "udif")

# 2PL model to test non-uniform DIF
formulaNLR(model = "2PL", type = "nudif")

# 4PL model to test all possible DIF
# with alternative parameterization
formulaNLR(model = "4PL", type = "all", parameterization = "alternative")

# 4PL model with fixed a and c parameter
# to test difference in b with alternative parameterization
formulaNLR(model = "4PL", constraints = "ac", type = "b", parameterization = "alternative")
}
\seealso{
\code{\link[difNLR]{difNLR}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
