% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInterval.R
\name{checkInterval}
\alias{checkInterval}
\title{Checks interval bounds.}
\usage{
checkInterval(x, vec)
}
\arguments{
\item{x}{numeric.}

\item{vec}{numeric: increasingly sorted bounds of interval.}
}
\description{
Checks whether \code{x} lies in interval defined by bounds in \code{vec}. If it does,
it returns value of \code{x}. In case that value of \code{x} is lower than lower bound specified
in \code{vec}, it returns its value. In case that value of \code{x} is greater than upper bound specified
in \code{vec}, it returns its value.
}
\examples{
\dontrun{
checkInterval(x = 0.5, vec = c(0, 1))
checkInterval(x = 1.5, vec = c(0, 1))
checkInterval(x = -0.5, vec = c(0, 1))
}

}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
