% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_dgm_friendly.R
\name{is_dgm_friendly}
\alias{is_dgm_friendly}
\title{Informs if a dataset is digiRhythm Friendly}
\usage{
is_dgm_friendly(data, verbose = FALSE)
}
\arguments{
\item{data}{The dataframe containing the activity data}

\item{verbose}{if TRUE, prints info about the dataset}
}
\value{
Boolean. If True, the dataframe is digirhythm friendly. If False, the
dataframe is not digirhythm friendly.
}
\description{
Takes an activity dataset as input and gives information about 1) If a
dataset is digiRhythm friendly, i.e., the functions used can work with this
dataset and 2) Tells what's wrong, if any.
}
\examples{
data("df516b_2", package = "digiRhythm")
d <- df516b_2
is_dgm_friendly(data = d, verbose = TRUE)
}
