% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/bootstrap.R
\docType{methods}
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap-method}
\alias{bootstrap,CA-method}
\alias{bootstrap,PCA-method}
\title{Partial Bootstrap Analysis}
\usage{
bootstrap(object, ...)

\S4method{bootstrap}{CA}(object, n = 30)

\S4method{bootstrap}{PCA}(object, n = 30)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
A \code{\linkS4class{BootstrapCA}} or \code{\linkS4class{BootstrapPCA}} object.
}
\description{
Checks analysis with partial bootstrap resampling.
}
\examples{
library(ggrepel)

## Partial bootstrap on CA
## Data from Lebart et al. 2006, p. 170-172
color <- data.frame(
  brun = c(68, 15, 5, 20),
  chatain = c(119, 54, 29, 84),
  roux = c(26, 14, 14, 17),
  blond = c(7, 10, 16, 94),
  row.names = c("marron", "noisette", "vert", "bleu")
)

## Compute correspondence analysis
X <- ca(color)

## Plot results
plot(X) +
  ggrepel::geom_label_repel()

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

\donttest{
## Get replicated coordinates
get_replications(Y, margin = 1)
get_replications(Y, margin = 2)
}

## Plot with ellipses
plot_rows(Y) +
  ggplot2::stat_ellipse()

plot_columns(Y) +
  ggplot2::stat_ellipse()

## Partial bootstrap on PCA
## Compute principal components analysis
data(iris)
X <- pca(iris)

## Plot results
plot_columns(X) +
  ggrepel::geom_label_repel()

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

## Plot with ellipses
plot_columns(Y) +
  ggplot2::stat_ellipse()
}
\references{
Greenacre, Michael J. \emph{Theory and Applications of Correspondence
Analysis}. London: Academic Press, 1984.

Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.
}
\seealso{
Other multivariate analysis: 
\code{\link{ca}()},
\code{\link{pca}()},
\code{\link{predict}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
