% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pca.R
\docType{methods}
\name{pca}
\alias{pca}
\alias{pca-method}
\alias{pca,data.frame-method}
\alias{pca,matrix-method}
\title{Principal Components Analysis}
\usage{
pca(object, ...)

\S4method{pca}{data.frame}(
  object,
  center = TRUE,
  scale = TRUE,
  rank = NULL,
  sup_row = NULL,
  sup_col = NULL,
  weight_row = NULL,
  weight_col = NULL
)

\S4method{pca}{matrix}(
  object,
  center = TRUE,
  scale = TRUE,
  rank = NULL,
  sup_row = NULL,
  sup_col = NULL,
  weight_row = NULL,
  weight_col = NULL
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} numeric \code{\link{matrix}} or a
\code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{center}{A \code{\link{logical}} scalar: should the variables be shifted to be
zero centered?}

\item{scale}{A \code{\link{logical}} scalar: should the variables be scaled to unit
variance?}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of components
to be kept in the results. If \code{NULL} (the default), \eqn{p - 1} components
will be returned.}

\item{sup_row}{A \code{\link{numeric}} or \code{\link{logical}} vector specifying the indices of
the supplementary rows (individuals).}

\item{sup_col}{A \code{\link{numeric}} or \code{\link{logical}} vector specifying the indices of
the supplementary columns (variables).}

\item{weight_row}{A \code{\link{numeric}} vector specifying the active row (individual)
weights. If \code{NULL} (the default), no weights are used.}

\item{weight_col}{A \code{\link{numeric}} vector specifying the active column
(variable) weights. If \code{NULL} (the default), no weights are used.}
}
\value{
A \code{\linkS4class{PCA}} object.
}
\description{
Computes a principal components analysis based on the singular value
decomposition.
}
\examples{
## Load data
data("compiegne", package = "folio")

## Compute principal components analysis
X <- pca(compiegne, scale = TRUE, sup_col = 7:10)

## Get row coordinates
get_coordinates(X, margin = 1)

## Get column coordinates
get_coordinates(X, margin = 2)

## Get row contributions
get_contributions(X, margin = 1)

## Get correlations between variables and dimensions
get_correlations(X)

## Get eigenvalues
get_eigenvalues(X)
}
\references{
Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.
}
\seealso{
\code{\link[=mutator]{get_*()}}, \code{\link[stats:predict]{stats::predict()}}, \code{\link[=svd]{svd()}}

Other multivariate analysis: 
\code{\link{ca}()},
\code{\link{predict}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
