% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CA-class}
\alias{CA-class}
\alias{.CA}
\title{CA Results}
\description{
An S4 class to store the results of a simple correspondence analysis.
}
\note{
This class inherits from \code{\linkS4class{MultivariateAnalysis}}.
}
\examples{
## Data from Lebart et al. 2006, p. 170-172
data("colours")

## The chi square of independence between the two variables
stats::chisq.test(colours)

## Compute correspondence analysis
X <- ca(colours)

## Plot rows
viz_rows(X, labels = TRUE)

## Plot columns
viz_columns(X, labels = TRUE)

## Get row coordinates
head(get_coordinates(X, margin = 1))

## Get column coordinates
head(get_coordinates(X, margin = 2))

## Get row distances to centroid
head(get_distances(X, margin = 1))

## Get row inertias
head(get_inertia(X, margin = 1))

## Get row contributions
head(get_contributions(X, margin = 1))

## Get eigenvalues
get_eigenvalues(X)
}
\seealso{
Other class: 
\code{\link{BootstrapCA-class}},
\code{\link{BootstrapPCA-class}},
\code{\link{MCA-class}},
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}},
\code{\link{PCA-class}}
}
\author{
N. Frerebeau
}
\concept{class}
\keyword{internal}
