% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daSolve.R
\name{daSolve}
\alias{daSolve}
\title{Rayleigh’s Method of Dimensional Analysis}
\usage{
daSolve(dv, iv)
}
\arguments{
\item{dv}{dependent variable}

\item{iv}{independent variables}
}
\value{
fundamental dimensions (MLT equations) and the solution
}
\description{
Performs Rayleigh’s method of dimensional analysis
}
\details{
The study of the relationship between physical quantities with the help of dimensions and units of
measurement is termed as dimensional analysis. Dimensional analysis is essential because it keeps the
units the same, helping us perform mathematical calculations smoothly. Dimensional Analysis
(also called Factor-Label Method or the Unit Factor Method) is a problem-solving method that uses
the fact that any number or expression can be multiplied by one without changing its value.

Rayleigh’s method of dimensional analysis is a conceptual tool used in physics, chemistry, and
engineering. This form of dimensional analysis expresses a functional relationship of some variables
in the form of an exponential equation. It was named after Lord Rayleigh.

Here are the types and variables:\tabular{lcr}{
   Type \tab Variable \tab  \cr
   Geometric \tab 'length', 'area', 'volume', 'curvature', 'slope', 'angle', 'shape factore', 'diameter', 'distance' \tab  \cr
   Kinematic \tab 'time', 'linear velocity', 'angular velocity', 'velocity','frequency', 'linear acceleration', 'angular acceleration','gravitational acceleration', 'discharge per unit width', 'kinematic viscosity', 'circulation' \tab  \cr
   Dynamic \tab 'mass', 'force', 'weight', 'density', 'specific weight', 'specific gravity', 'pressure','stress', 'shear stress', 'strain', 'dynamic viscosity', 'surface tension', 'modulus of elasticity', 'compressibility', 'impulse','momentum', 'work', 'energy', 'torque', 'power', 'weight rate of flow', 'viscosity' \tab  \cr
}
}
\examples{
\dontrun{
## Example 1:
daSolve(dv = "force",
       iv = c("mass", "velocity", "length"))

## Example 2
daSolve(dv = "force",
       iv = c("velocity", "diameter",
              "density", "viscosity"))
}

}
